#version 330 core

in vec2 out_uvs;
out vec4 FragColor;

uniform sampler2D inTex;
uniform float posX;
uniform float posY;
uniform float decayF;
uniform float densityF;
uniform float weightF; // was moved to preProc but not effective there since RGB values blow out but alpha values remain miniscule
uniform float thresholdF;
uniform float samplesF;
uniform float jitterF;
uniform int modeL;
uniform int forwardL;
uniform int backwardL;
uniform int aberration_channelL;
uniform int unmultL;
uniform float caF;
uniform float aspectF;

// 2x1 hash. Used to jitter the samples.
float hash( vec2 p ){ return fract(sin(dot(p, vec2(41, 289)))*45758.5453); }

vec2 modifyCoords(float rot)
{
// rotation
float sin_factor = sin(rot);
float cos_factor = cos(rot);
vec2 rotCoords = out_uvs;

vec2 aspectRatio = vec2(aspectF, 1.0); // tmp hardcode
vec2 posV = vec2(posX, posY);

rotCoords -= posV;
rotCoords /= aspectRatio;
rotCoords *= mat2(cos_factor, sin_factor, -sin_factor, cos_factor);
rotCoords *= aspectRatio;
rotCoords += posV;

return rotCoords;
}

void main()
{
    float SAMPLES = samplesF;
    vec2 uv = out_uvs;
    float decay = 1.0 - ((1.0 / SAMPLES) * decayF);
    //float density = densityF;
    float density = min(densityF, 1.0); // don't let the rays go beyond the size of the comp, stops weird things happening
    //float weight = (weightF / SAMPLES) * 100.0;
    float weightNorm = (1.0 / SAMPLES) * weightF;
    float weight = weightNorm;
    vec2 pos = vec2(posX,posY);
    vec2 tuv =  uv - pos;
    vec2 dTuv = tuv*density/SAMPLES;
    vec4 col = vec4(0.0);
    float caMult = 1.0 + caF;

    vec3 channelWeightV = vec3(1.0);

    // shared CA vars
    vec4 colR = vec4(0.0);
    vec4 colG = vec4(0.0);
    vec4 colB = vec4(0.0);

    // zoom specific CA vars
    float ca_modF;
    vec2 uvR;
    vec2 uvG;
    vec2 uvB;
    vec2 dTuvR;
    vec2 dTuvG;
    vec2 dTuvB;

    // spin specific CA vars
    vec3 counterV = vec3(0.0);

    // spin specific vars
    float incrF = (densityF * 0.01) / SAMPLES;
    float counter = 0.0;
    float jitterScratchF = jitterF * 0.01;
    float random = 0.0;
    float fuzz = 0.0;

    if(caF != 0.0)
    {
    ca_modF = caF * 0.1;

    if(aberration_channelL == 1)
    {
    dTuvR = tuv*(density+ca_modF)/SAMPLES;
    dTuvG = tuv*(density)/SAMPLES;
    dTuvB = tuv*(density-ca_modF)/SAMPLES;

    channelWeightV.r += caF;
    channelWeightV.b -= caF;
    }
    else if(aberration_channelL == 2)
    {
    dTuvR = tuv*(density+ca_modF)/SAMPLES;
    dTuvB = tuv*(density)/SAMPLES;
    dTuvG = tuv*(density-ca_modF)/SAMPLES;

    channelWeightV.r += caF;
    channelWeightV.g -= caF;
    }
    else
    {
    dTuvG = tuv*(density+ca_modF)/SAMPLES;
    dTuvR = tuv*(density)/SAMPLES;
    dTuvB = tuv*(density-ca_modF)/SAMPLES;

    channelWeightV.g += caF;
    channelWeightV.b -= caF;
    }
    }

    vec4 colGamma;

    if(modeL == 2)
    {
    // zoom
    uv += dTuv*(hash(uv.xy)*jitterF - 1.0);

    uvR =uv;
    uvG =uv;
    uvB =uv;

    if(caF != 0.0)
    {
    if(forwardL == 1)
    {
    for(float i = 0.0; i < SAMPLES; i++)
    {
    colR += texture(inTex, uvR) * weight;
    colG += texture(inTex, uvG) * weight;
    colB += texture(inTex, uvB) * weight;
    weight *= decay;

    uvR -= dTuvR;
    uvG -= dTuvG;
    uvB -= dTuvB;
    }
    }

    if(backwardL == 1)
    {
    // reset params just in case we did a forward op
    uv = out_uvs;
    uv += dTuv*(hash(uv.xy)*jitterF - 1.0);
    uvR =uv;
    uvG =uv;
    uvB =uv;
    weight = weightNorm;

    // if backward AND forward, move the sample now so we don't get 2 samples in the same spot
    if(forwardL == 1)
    {
    uvR += dTuvR;
    uvG += dTuvG;
    uvB += dTuvB;
    }

    for(float i = 0.0; i < SAMPLES; i++)
    {
    colR += texture(inTex, uvR) * weight;
    colG += texture(inTex, uvG) * weight;
    colB += texture(inTex, uvB) * weight;
    weight *= decay;

    uvR += dTuvR;
    uvG += dTuvG;
    uvB += dTuvB;
    }
    }

    col = vec4(colR.r, colG.g, colB.b, (colR.a + colG.a + colB.a) * 0.333);
    }
    else
    {
    if(forwardL == 1)
    {
    for(float i = 0.0; i < SAMPLES; i++)
    {
    col += texture(inTex, uv) * weight;
    weight *= decay;
    uv -= dTuv;
    }
    }

    if(backwardL == 1)
    {
    // reset params just in case we did a forward op
    uv = out_uvs;
    uv += dTuv*(hash(uv.xy)*jitterF - 1.0);
    weight = weightNorm;

    // if backward AND forward, move the sample now so we don't get 2 samples in the same spot
    if(forwardL == 1)
    {
    uv += dTuv;
    }

    for(float i = 0.0; i < SAMPLES; i++)
    {
    col += texture(inTex, uv) * weight;
    weight *= decay;
    uv += dTuv;
    }
    }
    }
    }
    else // spin
    {
    random = abs((hash(uv.xy)*jitterScratchF));
    random *= densityF * 0.1;

    if(caF != 0.0)
    {
    for(float i = 0.0; i < SAMPLES; i++)
    {
    fuzz = (random * (i / SAMPLES));

    // 3 texture samples. generate alpha from those

    colR += texture(inTex, modifyCoords(counterV.r + fuzz)) * vec4(weight);
    colR += texture(inTex, modifyCoords(-(counterV.r + fuzz))) * vec4(weight);

    colG += texture(inTex, modifyCoords(counterV.g + fuzz)) * vec4(weight);
    colG += texture(inTex, modifyCoords(-(counterV.g + fuzz))) * vec4(weight);

    colB += texture(inTex, modifyCoords(counterV.b + fuzz)) * vec4(weight);
    colB += texture(inTex, modifyCoords(-(counterV.b + fuzz))) * vec4(weight);

    counterV += vec3(incrF) * channelWeightV;
    weight *= decay;
    }

    col = vec4(colR.r, colG.g, colB.b, (colR.a + colG.a + colB.a) * 0.333);
    }
    else
    {
    for(float i = 0.0; i < SAMPLES; i++)
    {
    fuzz = (random * (i / SAMPLES));

    col += texture(inTex, modifyCoords(counter + fuzz)) * vec4(weight);
    col += texture(inTex, modifyCoords(-(counter + fuzz))) * vec4(weight);
    counter += incrF;
    weight *= decay;
    }
    }
    }

    FragColor = col;

    if(unmultL == 1)
    {
        float brightest = max(FragColor.r, FragColor.g);

        brightest = max(brightest, FragColor.b);
        brightest = min(brightest, 1.0); // make sure no HDR values, as this will affect the alpha

        if(brightest > 0.0)
        {
            FragColor = vec4(FragColor.r /= brightest, FragColor.g /= brightest, FragColor.b /= brightest, brightest);
        }
        else
        {
            FragColor = vec4(0.0);
        }
    }
    else
    {
        FragColor.a = min(FragColor.a, 1.0);
    }
    
    //FragColor = texture(inTex, out_uvs); // debug, show input buffer

    FragColor = FragColor.argb;
}
